package ga.view.streaming.showroom;

import ga.view.streaming.showroom.ShowRoomSettings.ShowRoomType;

import com.jme3.asset.AssetManager;
import com.jme3.system.AppSettings;

/**
 * A factory for creating ShowRoom objects.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class ShowRoomFactory {
  private final AssetManager assetManager;
  private final AppSettings settings;
  private final ShowRoomSettings showRoomSettings;

  private ShowRoom template;

  /**
   * Instantiates a new show room factory.
   * 
   * @param assetManager
   *          the asset manager
   * @param settings
   *          the settings
   * @param showRoomSettings
   *          the show room settings
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public ShowRoomFactory(final AssetManager assetManager,
      final AppSettings settings, final ShowRoomSettings showRoomSettings) {
    super();
    this.assetManager = assetManager;
    this.settings = settings;
    this.showRoomSettings = showRoomSettings;

    initShowRoom();
  }

  /**
   * Inits the show room.
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  private void initShowRoom() {
    final ShowRoomType type = showRoomSettings.getType();
    switch (type) {
    case BOX:
      template = new BoxShowRoom(assetManager, settings, showRoomSettings);

    default:

    }
  }

  /**
   * Creates a new ShowRoom object by cloning the template.
   * 
   * @return the show room
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public ShowRoom createShowRoom() {
    return createShowRoom(false);
  }

  /**
   * Creates a new ShowRoom object.
   * 
   * @param initNew
   *          init new or clone the template
   * @return the show room
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public ShowRoom createShowRoom(final boolean initNew) {
    if (initNew) {
      initShowRoom();
    }
    return (ShowRoom) template.clone();
  }
}
